(function () {
    let app = angular.module('contractRequest', []);

    app.directive('contractRequest', function () {
        return {
            restrict: 'E',
            templateUrl: 'templates/contractRequest.html',
            controller: function ($rootScope, $scope, $interval) {
                let ctrl = this;
                $scope.GetLocalized = Helpers.GetLocalized;
                ctrl.pricePerHour = $rootScope.settings.lastPricePerHour || 1;

                ctrl.sendOffer = () => {
                    let contract = $rootScope.contractRequest;

                    let pricePerHour = parseInt(ctrl.pricePerHour);
                    $rootScope.settings.lastPricePerHour = pricePerHour;

                    let offer = {};
                    offer.pricePerHour = pricePerHour;
                    offer.name = $rootScope.settings.companyName;
                    offer.created = $rootScope.settings.date;
                    offer.price = contract.chargeableHours * offer.pricePerHour;

                    contract.offers.push(offer);
                    contract.status = ContractStatuses.OfferSent;

                    let maxOffers = 3;

                    let interval = $interval(() => {
                        if (contract.offers.length < maxOffers) {
                            let newOffer = Generators.GenerateContractCompetitorOffer(contract);
                            let existingOfferFromSameCompany = contract.offers.find(x => x.name == newOffer.name);
                            if(existingOfferFromSameCompany == null) {
                                contract.offers.push(newOffer);
                            }
                        } else {
                            // Find winner
                            if (contract.offers.length) {
                                contract.winnerOffer = _.sortBy(contract.offers, 'price')[0];

                                if (!contract.winnerOffer.competitor) { // We won
                                    contract.status = ContractStatuses.Won;
                                    contract.pricePerHour = parseInt(contract.winnerOffer.pricePerHour);
                                    contract.price = contract.winnerOffer.price;
                                    $rootScope.settings.contracts.push(contract);

                                    let employee = Helpers.GetAllEmployees().find(x => x.task != null && x.task.contract != null && x.task.contract.id == contract.id);
                                    let task = employee.task;
                                    task.contractId = contract.id;
                                    task.contract = null;

                                    PlaySound(Sounds.toast);
                                } else { // We lost
                                    contract.status = ContractStatuses.Lost;
                                    contract.completed = true;
                                    Helpers.DetachContractFromEmployee(contract);

                                    PlaySound(Sounds.softFail);
                                }

                                Game.Lifecycle._update(0);
                                $rootScope.$broadcast(GameEvents.ContractChange);
                            }

                            $interval.cancel(interval);
                        }
                    }, 1000);
                };

                ctrl.acceptContract = () => {
                    let contract = $rootScope.contractRequest;
                    contract.status = ContractStatuses.Won;
                    $rootScope.settings.contracts.push(contract);

                    $rootScope.selectedWorkstation.employee.task.contractId = contract.id;
                    $rootScope.selectedWorkstation.employee.task.contract = null;

                    $rootScope.$broadcast(GameEvents.ContractChange);
                    ctrl.close();
                };

                ctrl.declineContract = () => {
                    let contract = $rootScope.contractRequest;
                    contract.status = ContractStatuses.Declined;
                    contract.completed = true;
                    $rootScope.settings.contracts.push(contract);
                    Helpers.DetachContractFromEmployee(contract);

                    Game.Lifecycle._update(0);

                    $rootScope.settings.maxContractHours--;
                    $rootScope.$broadcast(GameEvents.ContractChange);
                    ctrl.close();
                };

                ctrl.close = () => {
                    delete $rootScope.contractRequest;
                    Helpers.TakeCareOfResumingGame();
                }
            },
            controllerAs: 'ctrl'
        };
    });
})();
